/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: SCF card service bundle sample.
 *
 */

package scfbundle;

import jp.co.ricoh.dsdk.scard.framework.service.RegisterBundle;
import jp.co.ricoh.dsdk.scard.framework.util.DebugTrace;

/**
 * SCFCardServiceBundle class
 * This class extends RegisterBundle.
 * This class registers/removes MyAppletService and MyFileAccessService 
 * to/from the card service registry.
 * 
 * SCFCardServiceBundleクラス
 * RegisterBundleを継承します。
 * MyAppletService、MyFileAccessServiceをカードサービスレジストリに登録/削除します。
 */
public class SCFCardServiceBundle extends RegisterBundle{
	
	/*
	 * sets output level of the DebugTrace
	 * 出力レベル調整
	 */
	//static{
	//	DebugTrace.setLevel(10);
	//}
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.framework.service.RegisterBundle#getCardServices()
	 */
	protected Class[] getCardServices() throws Exception {
		return new Class[]{
				MyAppletService.class,
				MyFileAccessService.class
		};
	}

}
